#include <iostream>
using namespace std;
#define MAXV 500
const int INF = 0x3fffffff;
int dis[MAXV][MAXV], d[MAXV], num[MAXV] = {0}, weight[MAXV], w[MAXV] = {0};
bool vis[MAXV] = {false};
int n, m, st, ed;
void dijkstra(int s)
{
    fill(d, d + MAXV, INF);
    d[s] = 0;
    w[s] = weight[s];
    num[s] = 1;
    for (int i = 0; i < n; i++)
    {
        int v = -1, mindis = INF;
        for (int j = 0; j < n; j++)
        {
            if (!vis[j] && d[j] < mindis)
            {
                mindis = d[j];
                v = j;
            }
        }
        if (v == -1 || v == ed)
            return;
        vis[v] = true;
        for (int j = 0; j < n; j++)
        {
            if (!vis[j] && dis[v][j] != INF)
            {
                if (d[v] + dis[v][j] < d[j])
                {
                    d[j] = d[v] + dis[v][j];
                    num[j] = num[v];
                    w[j] = weight[j] + w[v];
                }
                else if (d[v] + dis[v][j] == d[j])
                {
                    num[j] += num[v];
                    if (weight[j] + w[v] > w[j])
                        w[j] = weight[j] + w[v];
                }
            }
        }
    }
}
int main()
{
    fill(dis[0], dis[0] + MAXV * MAXV, INF);
    scanf("%d%d%d%d", &n, &m, &st, &ed);
    for (int i = 0; i < n; i++)
        scanf("%d", &weight[i]);
    for (int i = 0; i < m; i++)
    {
        int s, e, l;
        scanf("%d%d%d", &s, &e, &l);
        dis[s][e] = dis[e][s] = l;
    }
    dijkstra(st);
    printf("%d %d", num[ed], w[ed]);
    return 0;
}
